/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.CaseInsensitiveString;

public class AgentState {
    private static final AgentState[] STATES = new AgentState[]{new AgentState("Illegal MIN state", 0), new AgentState("Initiated", 1), new AgentState("Active", 2), new AgentState("Idle", 3), new AgentState("Suspended", 4), new AgentState("Waiting", 5), new AgentState("Deleted", 6), new AgentState("Illegal MAX state", 13)};
    private Long persistentID;
    private String name;
    private int value;

    public static AgentState getInstance(int value) {
        int i = 0;
        while (i < STATES.length) {
            AgentState as = STATES[i];
            if (as.getValue() == value) {
                return as;
            }
            ++i;
        }
        return null;
    }

    public static AgentState[] getAllInstances() {
        return STATES;
    }

    public AgentState() {
    }

    private AgentState(String n, int v) {
        this.name = n;
        this.value = v;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(int v) {
        this.value = v;
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            return CaseInsensitiveString.equalsIgnoreCase(this.name, (String)o);
        }
        try {
            AgentState as = (AgentState)o;
            return CaseInsensitiveString.equalsIgnoreCase(this.name, as.name);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object o) {
        AgentState as = (AgentState)o;
        return this.name.toLowerCase().toUpperCase().compareTo(as.name.toLowerCase().toUpperCase());
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }
}

